"""PyTorch algorithms."""
# isort:skip_file

from garage.torch.algos.bc import BC
from garage.torch.algos.ddpg import DDPG
# VPG has to be imported first because it is depended by PPO and TRPO.
# PPO, TRPO, and VPG need to be imported before their MAML variants
from garage.torch.algos.dqn import DQN
from garage.torch.algos.vpg import VPG
from garage.torch.algos.maml_vpg import MAMLVPG
from garage.torch.algos.ppo import PPO
from garage.torch.algos.maml_ppo import MAMLPPO
from garage.torch.algos.td3 import TD3
from garage.torch.algos.trpo import TRPO
from garage.torch.algos.maml_trpo import MAMLTRPO
# SAC needs to be imported before MTSAC
from garage.torch.algos.sac import SAC
from garage.torch.algos.mtsac import MTSAC
from garage.torch.algos.pearl import PEARL

#RL2
from garage.torch.algos.rl2 import RL2
from garage.torch.algos.rl2ppo import RL2PPO

__all__ = [
    'BC', 'DDPG', 'DQN', 'VPG', 'PPO', 'TD3', 'TRPO', 'MAMLPPO', 'MAMLTRPO',
    'MAMLVPG', 'MTSAC', 'PEARL', 'SAC', 'RL2', 'RL2PPO'
]
